`timescale 1ns/1ns

`include "cpu.v"
`include "memory.v"
`include "arbiter.v"

/* Ovaj modul predstavlja jednostavni model racunara sa procesorom i memorijom.
 Modul se koristi za simulaciju. */
module computer;

   reg clk; // Casovnik
   wire [31:0] data, addr; // Magistrale podataka i adresa
   wire        bus_command, bus_request, bus_grant, bus_in_use, bus_wait; // Kontrolni signali na magistrali
   wire        halt_computer; // Signal za iskljucivanje racunara

      
   /* Memorija i procesor */
   memory _memory(clk, data, addr, bus_in_use, bus_command, bus_wait);
   cpu _cpu(clk, data, addr, bus_request, bus_grant, bus_in_use, bus_command, bus_wait, halt_computer);

   /* Arbitraza magistrale */
   arbiter _arbiter(clk, bus_request, bus_in_use, bus_grant);
      
   /* Proces koji inicijalizuje memoriju na osnovu sadrzaja datog fajla 
    Casovnik se postavlja na 0. */
   initial
     begin
	$readmemh("sabiranje.txt", _memory._regs);
	clk = 0;
     end

   /* Proces koji predstavlja casovnik koji menja svoje stanje svake nanosekunde 
      (sto odgovara frekvenciji od 500MHz) */
   always #1 clk = ~clk;      

   /* Proces koji se aktivira kada se ukljuci halt_signal i prekida simulaciju */
   always @(posedge halt_computer)
     begin
	$finish;
     end

   /* DEBUG */
   always @(data)
     $display($time, ": data: %h", data);

   always @(addr)
     $display($time, ": addr: %h", addr);

   always @(bus_in_use)
     $display($time, ": bus_in_use: %b", bus_in_use);
   
   always @(bus_command)
     $display($time, ": bus_command: %b", bus_command);

   always @(bus_wait)
     $display($time, ": bus_wait: %b", bus_wait);

   always @(bus_request)
     $display($time, ": bus_request: %b", bus_request);

   always @(bus_grant)
     $display($time, ": bus_grant: %b", bus_grant);

   

   
endmodule // computer

