`include "common.v"
`include "alu.v"
`include "mdr.v"
`include "mar.v"
`include "regs.v"
`include "ir.v"
`include "pc.v"
`include "ac.v"
`include "psw.v"

/* Datapath komponenta. Na ulazu ima signal casovnika, kao i kontrolne signale iz
 kontrolne jedinice. Na izlazu ka kontrolnoj jedinici ima stanje flegova kao i 
 dekodiranu instrukciju koja se trenutno izvrsava. Magistrala data je dvosmerna
 i povezuje datapath komponentu sa memorijom, dok je magistrala addr izlazna
 magistrala preko koje se salje adresa ka memoriji. */
module datapath(clk, psw_out, 
		ir_op_code, ir_dst_reg, ir_src_reg,
		e_reg_a_in, e_reg_b_in, e_reg_a_out, e_reg_b_out, 
		e_alu, 
		e_ac_alu_in, e_ac_a_out, e_ac_b_out,
		e_psw_in,
		e_pc_a_in, e_pc_b_in, e_pc_a_out, e_pc_b_out, e_pc_inc,
		e_ir_a_in, e_ir_b_in,
		e_mar_a_in, e_mar_b_in, e_addr_out, e_calc_addr,
		e_mdr_a_in, e_mdr_b_in, e_data_in, e_mdr_a_out, e_mdr_b_out, e_data_out, e_calc_const,  
		alu_op, reg_a_sel, reg_b_sel,
		data, addr);

   input clk; // signal casovnika
   output [3:0] psw_out; // izlaz: flegovi ka kontrolnoj jednici
   output [7:0] ir_op_code; // operacioni kod instrukcije
   output [3:0] ir_dst_reg; // odredisni registar instrukcije
   output [3:0] ir_src_reg; // izvorisni registar instrukcije

   /* Kontrolni signali iz kontrolne jedinice */
   input 	e_reg_a_in, e_reg_b_in, e_reg_a_out, e_reg_b_out, 
		e_alu, 
		e_ac_alu_in, e_ac_a_out, e_ac_b_out,
		e_psw_in,
		e_pc_a_in, e_pc_b_in, e_pc_a_out, e_pc_b_out, e_pc_inc,
		e_ir_a_in, e_ir_b_in,
		e_mar_a_in, e_mar_b_in, e_addr_out, e_calc_addr,
		e_mdr_a_in, e_mdr_b_in, e_data_in, e_mdr_a_out, e_mdr_b_out, e_data_out, e_calc_const;
   input [3:0] alu_op;   
   input [3:0] reg_a_sel;
   input [3:0] reg_b_sel;

   inout [31:0] data; // magistrala podataka
   output [31:0] addr; // adresna magistrala

   wire [31:0] 	 bus_a; // A magistrala
   wire [31:0] 	 bus_b; // B magistrala
   
   wire [31:0] 	 alu_out; // Izlaz iz ALU jedinice
   wire 	 o, s, z, c; // Flegovi

   /* Elementi datapath komponente */
   regs _regs(clk, bus_a, bus_b, reg_a_sel, reg_b_sel, e_reg_a_in, e_reg_b_in, e_reg_a_out, e_reg_b_out);
   alu _alu(e_alu, bus_a, bus_b, psw_out[`CF], alu_op, alu_out, o, s, z, c);
   psw _psw(clk, { o, s, z, c }, psw_out, e_psw_in);
   ac _ac(clk, bus_a, bus_b, alu_out, e_ac_alu_in, e_ac_a_out, e_ac_b_out);
   pc _pc(clk, bus_a, bus_b, e_pc_a_in, e_pc_b_in, e_pc_a_out, e_pc_b_out, e_pc_inc);
   ir _ir(clk, bus_a, bus_b, ir_op_code, ir_dst_reg, ir_src_reg, e_ir_a_in, e_ir_b_in);   
   mar _mar(clk, bus_a, bus_b, addr, e_mar_a_in, e_mar_b_in, e_addr_out, e_calc_addr);
   mdr _mdr(clk, bus_a, bus_b, data, e_mdr_a_in, e_mdr_b_in, e_data_in, e_mdr_a_out, e_mdr_b_out, e_data_out, e_calc_const);


   /* DEBUG procesi za nadgledanje magistrala */
   always @(bus_a)
     begin
	$display($time, ": bus_a: %x", bus_a);	
     end

   always @(bus_b)
     begin
	$display($time, ": bus_b: %x", bus_b);	
     end
   
endmodule // datapath

		
