module non_blocking;


   reg clk;
   reg a, b;
   


   /* Blokirajuca naredba proceduralne dodele (=) se izvrsava na isti
    nacin kao u proceduralnim programskim jezicima (poput C-a). Najpre
    se izracuna desna strana, pa se zatim ta vrednost dodeli levoj 
    strani. Tek nakon sto se izvrsi azuriranje leve strane, prelazi
    se na sledecu naredbu u bloku. Blokirajuca naredba dodele se 
    obicno koristi u dizajnu kombinatornih kola. */
   always @(posedge clk)
     begin
	a = b;	
	b = a;
     end


   /* Neblokirajuca naredba proceduralne dodele (<=) se izvrsava u dve
    faze: najpre se izracunaju sve desne strane u bloku, a onda se na
    kraju vremenske jedinice vrsi upisivanje u promenljive na levoj
    strani.  Zbog toga ce u donjem primeru u q biti upisana stara
    vrednost qp a u qp stara vrednost od q (pre upisa nove
    vrednosti). Neblokirajuce naredbe dodele se uglavnom koriste kod
    sekvencijalnih kola */
   always @(posedge clk)
     begin
        a <= b;
        b <= a;	     
     end
  

   reg [31:0] count;
   
   
   initial
     begin
	$monitor($time, ": clk: %b, a: %b, b: %b", clk, a, b);

	a = 0;
	b = 1;
	clk = 0;	

	for(count = 0; count < 10; count = count + 1)
	  #1 clk = ~clk;	
     end
   
endmodule // non_blocking
