// Sinhroni 4-bitni binarni brojac
// Pretpostavlja se da dvoulazno AND kolo ima kasnjenje 1, a troulazno 2
// Vreme propagacije flip-flopa je 1 vremenska jedinica
module sync(clk, q);
   input clk;
   output reg [3:0] q;

   initial
     q <= 0;

   wire [3:0] 	    t;  // T ulazi flip-flopova

   // Implementacija kombinatorne logike
   assign t[0] = 1;
   assign t[1] = q[0];
   assign #1 t[2] = q[0] & q[1];
   assign #2 t[3] = q[0] & q[1] & q[2];
   
   
   
   
   always @(posedge clk)
     begin
	q[0] <= #1 q[0] ^ t[0];
	q[1] <= #1 q[1] ^ t[0];
	q[2] <= #1 q[2] ^ t[2];	
	q[3] <= #1 q[3] ^ t[3];	
     end
endmodule
